import React, { SVGAttributes, forwardRef } from 'react';

import { useUniqId } from '@use-platform/react';

export interface KeyMailProps extends SVGAttributes<SVGSVGElement> {
  /**
   * Additional className for svg root
   */
  className?: string;
}

export const KeyMail = forwardRef<SVGSVGElement, KeyMailProps>((props, ref) => {
  const { className, ...otherProps } = props;
  const id = useUniqId();

  return (
    <svg
      width="32"
      height="32"
      viewBox="0 0 32 32"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path
        d="M2 14.8731C2 14.317 2.23156 13.786 2.6391 13.4075L13.2782 3.52837C14.8129 2.10326 17.1871 2.10326 18.7218 3.52837L29.3609 13.4075C29.7684 13.786 30 14.317 30 14.8731V27.001C30 29.2101 28.2091 31.001 26 31.001H6C3.79086 31.001 2 29.2101 2 27.001V14.8731Z"
        fill={`url(#${id}paint0_linear_2988_41730)`}
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M29.8501 14.1138L16.6 24.0514C16.2444 24.3181 15.7556 24.3181 15.4 24.0514L2.1499 14.1138C2.2588 13.8486 2.42456 13.6072 2.63909 13.4079L13.2782 3.52879C14.8129 2.10369 17.1871 2.10369 18.7218 3.52879L29.3609 13.4079C29.5754 13.6072 29.7412 13.8486 29.8501 14.1138Z"
        fill={`url(#${id}paint1_linear_2988_41730)`}
      />
      <path
        d="M3 15.001L15.4308 23.6069C15.7732 23.844 16.2268 23.844 16.5692 23.6069L29 15.001"
        stroke="url(#paint2_linear_2988_41730)"
        strokeWidth="2"
        strokeLinecap="round"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M11.363 8.45522C13.1943 8.45522 14.7621 9.58329 15.4094 11.1825L23.9087 11.1825L24.9996 12.2733L24.9998 12.2733L23.3635 13.9098L17.3634 13.9098L17.3634 12.2735L17.3629 12.2735L17.3632 14.4552L15.4095 14.4552C14.7622 16.0545 13.1943 17.1826 11.363 17.1826C8.95296 17.1826 6.99927 15.2289 6.99927 12.8189C6.99927 10.4089 8.95296 8.45522 11.363 8.45522ZM11.3632 12.8189C11.3632 12.0658 10.7527 11.4552 9.99956 11.4552C9.24643 11.4552 8.6359 12.0658 8.6359 12.8189C8.6359 13.572 9.24643 14.1825 9.99956 14.1825C10.7527 14.1825 11.3632 13.572 11.3632 12.8189Z"
        fill="#FFCC00"
      />
      <defs>
        <linearGradient
          id={`${id}paint0_linear_2988_41730`}
          x1="16"
          y1="1.00098"
          x2="16"
          y2="31.001"
          gradientUnits="userSpaceOnUse"
        >
          <stop offset="0.296571" stopColor="#c1deff" />
          <stop offset="1" stopColor="#0077ff" />
        </linearGradient>
        <linearGradient
          id={`${id}paint1_linear_2988_41730`}
          x1="16"
          y1="2.45996"
          x2="16"
          y2="24.2514"
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="#9ccaff" />
          <stop offset="1" stopColor="#0077ff" />
        </linearGradient>
        <linearGradient
          id={`${id}paint2_linear_2988_41730`}
          x1="16"
          y1="15.001"
          x2="16"
          y2="22.001"
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="#98c8ff" />
          <stop offset="1" stopColor="#b8d9ff" />
        </linearGradient>
      </defs>
    </svg>
  );
});
