import React, { SVGAttributes, forwardRef } from 'react';

import { useUniqId } from '@use-platform/react';

export interface KeyShieldProps extends SVGAttributes<SVGSVGElement> {
  /**
   * Additional className for svg root
   */
  className?: string;
}

export const KeyShield = forwardRef<SVGSVGElement, KeyShieldProps>((props, ref) => {
  const { className, ...otherProps } = props;
  const id = useUniqId();

  return (
    <svg
      width="32"
      height="32"
      viewBox="0 0 32 32"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M2.75917 2.55377C7.433 0.865541 12.5609 0.865541 17.2347 2.55377C18.028 2.8586 18.7118 3.38921 19.1995 4.07829C19.6871 4.76736 19.9566 5.58394 19.9739 6.42449V8.08328C19.3141 8.48812 18.6543 8.88316 17.9745 9.26825V6.42449C17.976 5.96138 17.8341 5.50887 17.5679 5.12766C17.3016 4.74645 16.9238 4.45472 16.485 4.29163C12.2877 2.78229 7.68618 2.78229 3.48893 4.29163C3.05009 4.45472 2.67224 4.74645 2.406 5.12766C2.13977 5.50887 1.99789 5.96138 1.99939 6.42449V11.1838C2.00313 11.6523 2.15171 12.1084 2.42504 12.4913C2.69837 12.8742 3.08345 13.1657 3.52895 13.3265C4.69545 13.7843 5.90875 14.1153 7.14772 14.3139L7.99756 14.4423V27.5947L9.99695 28.9178L11.9963 27.5947V14.4423L12.8462 14.3139C13.2261 14.2547 13.6158 14.1658 13.9957 14.077V28.661L9.99695 31.2876L5.99817 28.661V16.1209C4.91462 15.9065 3.85128 15.6026 2.81921 15.2124C2.00003 14.9129 1.29189 14.3751 0.788578 13.6699C0.285266 12.9648 0.0103799 12.1254 0 11.2627V6.50344C0.000202714 5.64641 0.264313 4.80972 0.757093 4.10432C1.24987 3.39892 1.94804 2.85813 2.75917 2.55377ZM6.3877 8.39928L5.60815 6.58234C8.32392 5.51593 11.3498 5.51593 14.0655 6.58234L13.2857 8.39928C11.0668 7.55017 8.60665 7.55017 6.3877 8.39928Z"
        fill="#272733"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M2.75917 2.55377C7.433 0.865541 12.5609 0.865541 17.2347 2.55377C18.028 2.8586 18.7118 3.38921 19.1995 4.07829C19.6871 4.76736 19.9566 5.58394 19.9739 6.42449V8.08328C19.3141 8.48812 18.6543 8.88316 17.9745 9.26825V6.42449C17.976 5.96138 17.8341 5.50887 17.5679 5.12766C17.3016 4.74645 16.9238 4.45472 16.485 4.29163C12.2877 2.78229 7.68618 2.78229 3.48893 4.29163C3.05009 4.45472 2.67224 4.74645 2.406 5.12766C2.13977 5.50887 1.99789 5.96138 1.99939 6.42449V11.1838C2.00313 11.6523 2.15171 12.1084 2.42504 12.4913C2.69837 12.8742 3.08345 13.1657 3.52895 13.3265C4.69545 13.7843 5.90875 14.1153 7.14772 14.3139L7.99756 14.4423V27.5947L9.99695 28.9178L11.9963 27.5947V14.4423L12.8462 14.3139C13.2261 14.2547 13.6158 14.1658 13.9957 14.077V28.661L9.99695 31.2876L5.99817 28.661V16.1209C4.91462 15.9065 3.85128 15.6026 2.81921 15.2124C2.00003 14.9129 1.29189 14.3751 0.788578 13.6699C0.285266 12.9648 0.0103799 12.1254 0 11.2627V6.50344C0.000202714 5.64641 0.264313 4.80972 0.757093 4.10432C1.24987 3.39892 1.94804 2.85813 2.75917 2.55377ZM6.3877 8.39928L5.60815 6.58234C8.32392 5.51593 11.3498 5.51593 14.0655 6.58234L13.2857 8.39928C11.0668 7.55017 8.60665 7.55017 6.3877 8.39928Z"
        fill={`url(#${id}paint0_linear_2988_32323)`}
      />
      <path
        d="M23.9924 26.3112L23.6625 26.1926C18.664 24.435 16.0049 20.0213 16.0049 13.4155V12.7737L16.5948 12.5169C18.9936 11.481 21.2725 10.1933 23.3925 8.67585L24.0124 8.22168L24.6221 8.69562C26.6905 10.2663 28.9593 11.5611 31.3701 12.5466L32 12.7934V13.455C32 20.13 29.3409 24.5437 24.3124 26.2025L23.9924 26.3112ZM17.9943 14.0475C18.1442 19.3104 20.1636 22.7268 23.9924 24.2178C27.8213 22.8058 29.8307 19.4091 29.9906 14.1067C27.8728 13.188 25.8617 12.0458 23.9924 10.7001C22.0931 11.9824 20.0864 13.1023 17.9943 14.0475Z"
        fill="#272733"
      />
      <path
        d="M23.9924 26.3112L23.6625 26.1926C18.664 24.435 16.0049 20.0213 16.0049 13.4155V12.7737L16.5948 12.5169C18.9936 11.481 21.2725 10.1933 23.3925 8.67585L24.0124 8.22168L24.6221 8.69562C26.6905 10.2663 28.9593 11.5611 31.3701 12.5466L32 12.7934V13.455C32 20.13 29.3409 24.5437 24.3124 26.2025L23.9924 26.3112ZM17.9943 14.0475C18.1442 19.3104 20.1636 22.7268 23.9924 24.2178C27.8213 22.8058 29.8307 19.4091 29.9906 14.1067C27.8728 13.188 25.8617 12.0458 23.9924 10.7001C22.0931 11.9824 20.0864 13.1023 17.9943 14.0475Z"
        fill={`url(#${id}paint1_linear_2988_32323)`}
      />
      <defs>
        <linearGradient
          id={`${id}paint0_linear_2988_32323`}
          x1="9.38339"
          y1="2.68948"
          x2="9.38339"
          y2="30.3401"
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="#ff8a00" />
          <stop offset="1" stopColor="#ff0000" />
        </linearGradient>
        <linearGradient
          id={`${id}paint1_linear_2988_32323`}
          x1="24.0024"
          y1="8.22168"
          x2="24.0024"
          y2="26.3112"
          gradientUnits="userSpaceOnUse"
        >
          <stop offset="0.346995" stopColor="#58c800" />
          <stop offset="1" stopColor="#00b649" />
        </linearGradient>
      </defs>
    </svg>
  );
});
