import React, { SVGAttributes, forwardRef } from 'react';

export interface YandexKeyProps extends SVGAttributes<SVGSVGElement> {
  /**
   * Additional className for svg root
   */
  className?: string;
  /**
   * Icon size
   *
   * @default 24
   */
  size?: 12 | 16 | 24 | 32;
}

export const YandexKey = forwardRef<SVGSVGElement, YandexKeyProps>((props, ref) => {
  const { className, size = 24, ...otherProps } = props;

  return (
    <svg
      width={size}
      height={size}
      viewBox="0 0 24 24"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M8.63357 15.6631C5.33805 15.6631 2.6665 12.9916 2.6665 9.69607C2.6665 6.40055 5.33805 3.729 8.63357 3.729C11.9291 3.729 14.6006 6.40055 14.6006 9.69607C14.6006 12.9916 11.9291 15.6631 8.63357 15.6631ZM7.14908 10.0745C8.17793 10.0745 9.01197 9.24043 9.01197 8.21158C9.01197 7.18274 8.17793 6.34869 7.14908 6.34869C6.12024 6.34869 5.28619 7.18274 5.28619 8.21158C5.28619 9.24043 6.12024 10.0745 7.14908 10.0745Z"
        fill="#FFCC00"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M20.8719 20.2409L20.4486 19.3942L14.5212 13.4668L12.8276 15.1603L17.9082 20.2509L20.8719 20.2409Z"
        fill="#EFB30E"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M20.8716 20.2409L21.2949 18.5473L12.4039 9.65625L9.44019 13.0433L12.4039 16.007L14.5208 13.8901L20.8716 20.2409Z"
        fill="#FFCC00"
      />
    </svg>
  );
});
