import React, { SVGAttributes, forwardRef } from 'react';

import { DocumentType } from '@client/shared/api/graphql';

export interface IDocumentPlusProps extends SVGAttributes<SVGSVGElement> {
  className?: string;
  /**
   * Icon size
   *
   * @default 24
   */
  size?: 20 | 24;

  /**
   * Icon color by document type.
   * Without type, color black.
   */
  type?: DocumentType;
}

const getExternalColorByType = (type?: DocumentType) => {
  switch (type) {
    case DocumentType.NationalId:
    case DocumentType.InternationalId:
      return '#d25a5a';
    case DocumentType.DriverLicense:
      return '#D24B8F';
    default:
      // default svg color
      return 'black';
  }
};

export const DocumentsPlus = forwardRef<SVGSVGElement, IDocumentPlusProps>((props, ref) => {
  const { className, type, size = 24, ...restProps } = props;

  const extColor = getExternalColorByType(type);

  return (
    <svg
      width={size}
      height={size}
      viewBox="0 0 24 24"
      fill="none"
      {...restProps}
      ref={ref}
      className={'SvgIcon' + (className ? ' ' + className : '')}
    >
      <path
        d="M0 12C0 5.37258 5.37258 0 12 0C18.6274 0 24 5.37258 24 12C24 18.6274 18.6274 24 12 24C5.37258 24 0 18.6274 0 12Z"
        fill={extColor}
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M12 7C11.4477 7 11 7.44772 11 8V11L8 11C7.44771 11 7 11.4477 7 12C7 12.5523 7.44772 13 8 13H11V16C11 16.5523 11.4477 17 12 17C12.5523 17 13 16.5523 13 16V13H16C16.5523 13 17 12.5523 17 12C17 11.4477 16.5523 11 16 11L13 11V8C13 7.44772 12.5523 7 12 7Z"
        fill="white"
      />
    </svg>
  );
});
