import React, { SVGAttributes, forwardRef } from 'react';

export interface CarProps extends SVGAttributes<SVGSVGElement> {
  /**
   * Additional className for svg root
   */
  className?: string;
  /**
   * Icon size
   *
   * @default 24
   */
  size?: 12 | 16 | 24 | 32;
}

export const Car = forwardRef<SVGSVGElement, CarProps>((props, ref) => {
  const { className, size = 24, ...otherProps } = props;

  return (
    <svg
      width={size}
      height={size}
      viewBox="0 0 25 25"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M5.20414 12.002L4.79788 12.6114C4.36485 13.2609 4.13378 14.0241 4.13378 14.8047V17.002H20.1338V14.8047C20.1338 14.0241 19.9027 13.2609 19.4697 12.6114L19.0634 12.002H5.20414ZM18.0942 10.002L17.4635 6.84855C17.425 6.65611 17.2775 6.50399 17.0863 6.45958C15.8207 6.16555 14.1817 6.00195 12.1338 6.00195C10.0859 6.00195 8.4468 6.16555 7.1812 6.45958C6.99004 6.50399 6.84254 6.65612 6.80405 6.84855L6.17338 10.002H18.0942ZM4.53377 8.00195L4.84288 6.45633C5.03532 5.49415 5.77282 4.73351 6.7286 4.51146C8.19065 4.17179 9.99238 4.00195 12.1338 4.00195C14.2752 4.00195 16.0769 4.17179 17.5389 4.51146C18.4947 4.73351 19.2322 5.49415 19.4246 6.45632L19.7338 8.00195H21.4204C21.9779 8.00195 22.3406 8.58869 22.0912 9.08736L21.8412 9.58736C21.7142 9.84145 21.4545 10.002 21.1704 10.002H20.1758C20.2244 10.1167 20.2838 10.227 20.3532 10.3312L21.1338 11.502C21.7858 12.48 22.1338 13.6292 22.1338 14.8047V21.252C22.1338 21.6662 21.798 22.002 21.3838 22.002H19.7691C19.4025 22.002 19.0896 21.7369 19.0293 21.3753L18.6338 19.002H5.63378L5.23823 21.3753C5.17795 21.7369 4.86506 22.002 4.49843 22.002H2.88378C2.46956 22.002 2.13378 21.6662 2.13378 21.252V14.8047C2.13378 13.6292 2.48173 12.48 3.13378 11.502L3.91431 10.3312C3.98377 10.227 4.04313 10.1167 4.09175 10.002H3.09716C2.81308 10.002 2.55338 9.84145 2.42634 9.58736L2.17634 9.08736C1.927 8.58869 2.28962 8.00195 2.84716 8.00195H4.53377ZM6.63378 16.002C7.4622 16.002 8.13378 15.3304 8.13378 14.502C8.13378 13.6735 7.4622 13.002 6.63378 13.002C5.80535 13.002 5.13378 13.6735 5.13378 14.502C5.13378 15.3304 5.80535 16.002 6.63378 16.002ZM19.1338 14.502C19.1338 15.3304 18.4622 16.002 17.6338 16.002C16.8053 16.002 16.1338 15.3304 16.1338 14.502C16.1338 13.6735 16.8053 13.002 17.6338 13.002C18.4622 13.002 19.1338 13.6735 19.1338 14.502Z"
        fill="currentColor"
      />
    </svg>
  );
});
