import React, { SVGAttributes, forwardRef } from 'react';

import { useUniqId } from '@use-platform/react';

export interface EdadealProps extends SVGAttributes<SVGSVGElement> {
  /**
   * Additional className for svg root
   */
  className?: string;
  /**
   * Icon size
   *
   * @default 24
   */
  size?: 12 | 16 | 24 | 32;
}

export const Edadeal = forwardRef<SVGSVGElement, EdadealProps>((props, ref) => {
  const { className, size = 24, ...otherProps } = props;
  const id = useUniqId();

  return (
    <svg
      width={size}
      height={size}
      viewBox="0 0 40 40"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <rect width="40" height="40" rx="20" fill="#B5F2C3" />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M26.1617 39.0329C24.2207 39.6608 22.15 40 20 40C14.545 40 9.60005 37.8161 5.99184 34.2749C6.61736 31.0313 8.11768 29.0979 9.04398 27.9042C9.18456 27.723 9.31191 27.5589 9.42098 27.4098C6.73453 26.6057 4.87218 25.1723 4.41706 23.2357C4.07977 21.8005 4.61436 20.2588 5.70367 18.7905C4.42204 15.3789 5.24734 11.7861 7.85329 10.2821C8.96132 9.64265 10.2357 9.47161 11.5125 9.70149C11.9093 8.8986 12.5022 8.23009 13.2818 7.78016C15.5242 6.48604 18.5597 7.4211 20.5475 9.84936C27.4971 7.13039 33.5563 7.53731 35.2114 10.7695C36.6029 13.487 35.2245 16.0654 35.2245 16.0654C36.2565 20.2172 30.0734 25.3369 21.7083 27.2515C19.9771 27.6477 16.2145 28.1233 16.0093 28.1309C19.3281 29.4047 23.9978 35.7631 26.1617 39.0329Z"
        fill={`url(#${id}paint0_linear_321_3585)`}
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M32.7188 35.4355C29.9307 37.7355 26.5089 39.2947 22.7545 39.8119C21.1367 34.0797 17.4751 29.4297 13.3227 27.4944C10.4405 26.1511 8.47283 24.3664 8.85679 21.5277C18.2904 25.4362 32.017 20.2101 35.2248 16.0657C36.2471 19.5187 31.4905 24.3674 24.647 26.4612C26.4871 27.3421 30.8694 29.8478 32.7188 35.4355Z"
        fill={`url(#${id}paint1_linear_321_3585)`}
      />
      <path
        d="M15.1138 8.82204C14.4837 9.11491 13.9612 9.59763 13.6195 10.2025C13.606 10.2255 13.5929 10.2488 13.5803 10.2727C13.5794 10.2744 13.5784 10.2761 13.5775 10.2778C13.3479 10.7065 13.2149 11.1802 13.1876 11.6657C13.1604 12.1512 13.2395 12.6368 13.4196 13.0886C13.562 13.0141 13.7052 12.9399 13.8491 12.8662C13.8927 12.8438 13.9365 12.8214 13.9803 12.7992C14.0822 12.7471 14.1843 12.6953 14.2867 12.6437C14.3362 12.6187 14.3858 12.5938 14.4354 12.5689C14.5373 12.5179 14.6393 12.4671 14.7416 12.4166C14.7865 12.3943 14.8314 12.3721 14.8764 12.3499C15.0104 12.2839 15.1446 12.2184 15.279 12.1533C15.2904 12.1477 15.3018 12.1421 15.3132 12.1366C15.4617 12.0648 15.6103 11.9936 15.759 11.923C15.7954 11.9057 15.8318 11.8887 15.8682 11.8715C15.9799 11.8186 16.0915 11.7661 16.2031 11.7139C16.249 11.6925 16.2949 11.6712 16.3407 11.6499C16.4466 11.6007 16.5524 11.5519 16.658 11.5035C16.7014 11.4836 16.7449 11.4637 16.7883 11.4438C16.9132 11.3868 17.0379 11.3303 17.1623 11.2744C17.9557 10.9177 18.7362 10.5836 19.4803 10.2817C19.0779 9.52575 18.4007 8.95297 17.5883 8.6814C16.7759 8.40983 15.8902 8.46017 15.1138 8.82204Z"
        fill="#F0F0F0"
      />
      <path
        d="M14.2569 9.60279C13.963 9.73975 13.7354 9.97516 13.5775 10.2767H13.5775C13.3479 10.7054 13.2149 11.1791 13.1876 11.6646C13.1604 12.1501 13.2395 12.6357 13.4196 13.0875C13.562 13.013 13.7052 12.9389 13.8491 12.8651C13.8927 12.8427 13.9365 12.8203 13.9803 12.7981C14.0822 12.7461 14.1843 12.6942 14.2867 12.6426C14.3362 12.6176 14.3858 12.5927 14.4354 12.5679C14.5373 12.5168 14.6393 12.466 14.7416 12.4155C14.7865 12.3932 14.8314 12.371 14.8764 12.3488C15.0104 12.2828 15.1446 12.2173 15.279 12.1522C15.2904 12.1467 15.3018 12.141 15.3132 12.1355C15.4617 12.0637 15.6103 11.9925 15.759 11.922C15.7954 11.9047 15.8318 11.8876 15.8682 11.8704C15.9799 11.8175 16.0915 11.765 16.2031 11.7129C16.249 11.6914 16.2949 11.6701 16.3407 11.6488C16.4466 11.5997 16.5524 11.5508 16.658 11.5024C16.7014 11.4825 16.7449 11.4626 16.7883 11.4427C16.9132 11.3857 17.0379 11.3292 17.1623 11.2733C17.1799 11.2654 17.1977 11.2572 17.2153 11.2493C16.4879 9.89383 15.2025 9.162 14.2569 9.60279Z"
        fill="black"
      />
      <path
        d="M9.31808 11.3198C8.38449 11.7549 7.65768 12.537 7.2924 13.4998C6.92713 14.4625 6.95225 15.5297 7.36241 16.4742C7.37656 16.5064 7.39098 16.5386 7.40593 16.5706C7.45149 16.6683 7.5008 16.763 7.55312 16.8551C7.59296 16.8189 7.63396 16.7825 7.67549 16.746C7.68625 16.7366 7.69707 16.7271 7.70796 16.7176C7.74679 16.6838 7.78627 16.6498 7.8264 16.6157C7.82996 16.6127 7.8334 16.6097 7.83697 16.6067C7.88039 16.57 7.92484 16.5331 7.96985 16.4961C7.98142 16.4865 7.99311 16.477 8.00478 16.4675C8.04497 16.4347 8.08572 16.4017 8.12705 16.3687C8.13333 16.3637 8.13946 16.3587 8.14577 16.3537C8.19254 16.3165 8.24011 16.2792 8.28847 16.2417C8.30067 16.2323 8.31299 16.2228 8.32529 16.2133C8.3673 16.1809 8.40984 16.1484 8.45291 16.1158C8.46121 16.1095 8.46937 16.1033 8.47771 16.097C8.52792 16.0592 8.57885 16.0213 8.63051 15.9832C8.64267 15.9743 8.65497 15.9653 8.66722 15.9563C8.71142 15.9239 8.75611 15.8914 8.80128 15.8588C8.8115 15.8515 8.8216 15.8441 8.83186 15.8367C8.88518 15.7985 8.93917 15.7601 8.99382 15.7216C9.0058 15.7132 9.01793 15.7047 9.02998 15.6963C9.07656 15.6636 9.1236 15.6309 9.17109 15.5982C9.18292 15.59 9.19466 15.5818 9.20655 15.5737C9.26282 15.535 9.3197 15.4962 9.37719 15.4574C9.38864 15.4496 9.40024 15.4419 9.41173 15.4342C9.46103 15.401 9.51075 15.3678 9.5609 15.3345C9.57403 15.3258 9.58709 15.3171 9.60028 15.3084C9.65944 15.2693 9.71914 15.2301 9.7794 15.1909C9.78981 15.1841 9.80036 15.1773 9.8108 15.1706C9.86286 15.1368 9.91532 15.103 9.9682 15.0692C9.98291 15.0597 9.99758 15.0503 10.0124 15.0409C10.0739 15.0016 10.136 14.9623 10.1985 14.923C10.2076 14.9173 10.2168 14.9116 10.2259 14.9059C10.2812 14.8712 10.3369 14.8366 10.3929 14.8019C10.4088 14.792 10.4248 14.7821 10.4407 14.7723C10.5046 14.7329 10.5689 14.6934 10.6337 14.654C10.6407 14.6497 10.6477 14.6455 10.6547 14.6412C10.7134 14.6056 10.7725 14.5699 10.8319 14.5342C10.8496 14.5236 10.8673 14.513 10.8851 14.5023C10.9507 14.4631 11.0166 14.4239 11.0829 14.3846C11.0874 14.382 11.0919 14.3794 11.0964 14.3767C11.1589 14.3398 11.2217 14.303 11.285 14.2661C11.3046 14.2547 11.3242 14.2432 11.3439 14.2318C11.4046 14.1965 11.4657 14.1611 11.5271 14.1258C11.5346 14.1215 11.542 14.1172 11.5495 14.1128C12.4031 13.6225 13.315 13.1346 14.2475 12.6638C13.7177 11.8931 12.9317 11.3351 12.0292 11.089C11.1266 10.8429 10.166 10.9247 9.31808 11.3198Z"
        fill="#F0F0F0"
      />
      <path
        d="M8.30505 12.2438C7.98324 12.398 7.71745 12.6486 7.54458 12.9607C7.24437 13.4923 7.07164 14.0863 7.03998 14.696C7.00831 15.3056 7.11858 15.9143 7.36209 16.4742C7.37624 16.5064 7.39066 16.5386 7.40562 16.5706C7.45118 16.6683 7.50048 16.763 7.5528 16.8551C7.59264 16.8189 7.63365 16.7825 7.67517 16.746C7.68593 16.7366 7.69676 16.7271 7.70764 16.7176C7.74648 16.6838 7.78596 16.6498 7.82608 16.6157C7.82964 16.6127 7.83308 16.6097 7.83665 16.6067C7.88007 16.57 7.92453 16.533 7.96953 16.496C7.98111 16.4865 7.99279 16.477 8.00447 16.4674C8.04465 16.4346 8.0854 16.4017 8.12673 16.3687C8.13301 16.3637 8.13914 16.3587 8.14545 16.3537C8.19222 16.3165 8.23979 16.2792 8.28815 16.2417C8.30035 16.2323 8.31268 16.2228 8.32497 16.2133C8.36699 16.1809 8.40953 16.1484 8.45259 16.1158C8.46089 16.1095 8.46905 16.1033 8.4774 16.097C8.5276 16.0592 8.57853 16.0212 8.6302 15.9832C8.64236 15.9742 8.65466 15.9652 8.6669 15.9563C8.7111 15.9239 8.75579 15.8914 8.80097 15.8588C8.81119 15.8514 8.82128 15.8441 8.83155 15.8367C8.88487 15.7984 8.93885 15.7601 8.9935 15.7216C9.00549 15.7132 9.01762 15.7047 9.02967 15.6963C9.07625 15.6636 9.12328 15.6309 9.17077 15.5981C9.1826 15.59 9.19434 15.5818 9.20623 15.5736C9.26251 15.535 9.31939 15.4962 9.37687 15.4574C9.38832 15.4496 9.39992 15.4419 9.41142 15.4341C9.46071 15.401 9.51043 15.3677 9.56059 15.3345C9.57372 15.3258 9.58678 15.3171 9.59996 15.3083C9.65912 15.2692 9.71883 15.2301 9.77909 15.1909C9.7895 15.1841 9.80004 15.1773 9.81049 15.1705C9.86254 15.1368 9.915 15.103 9.96788 15.0691C9.9826 15.0597 9.99726 15.0503 10.012 15.0409C10.0736 15.0016 10.1357 14.9623 10.1982 14.923C10.2073 14.9173 10.2165 14.9116 10.2256 14.9059C10.2809 14.8712 10.3365 14.8365 10.3926 14.8018C10.4085 14.792 10.4244 14.7821 10.4404 14.7723C10.5043 14.7329 10.5686 14.6934 10.6334 14.6539C10.6404 14.6497 10.6474 14.6455 10.6544 14.6412C10.7131 14.6056 10.7721 14.5699 10.8316 14.5342C10.8493 14.5236 10.867 14.513 10.8848 14.5023C10.9503 14.4631 11.0163 14.4239 11.0826 14.3846C11.0871 14.382 11.0916 14.3793 11.0961 14.3767C11.1585 14.3398 11.2214 14.303 11.2847 14.2661C11.3042 14.2547 11.3239 14.2432 11.3435 14.2318C11.4043 14.1965 11.4654 14.1611 11.5267 14.1258C11.5343 14.1215 11.5417 14.1172 11.5492 14.1128C11.6019 14.0825 11.6549 14.0523 11.708 14.022C10.8351 12.5279 9.3831 11.7413 8.30505 12.2438Z"
        fill="black"
      />
      <defs>
        <linearGradient
          id={`${id}paint0_linear_321_3585`}
          x1="5.25606"
          y1="21.6704"
          x2="36.6272"
          y2="21.6704"
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="#279B53" />
          <stop offset="1" stopColor="#39E674" />
        </linearGradient>
        <linearGradient
          id={`${id}paint1_linear_321_3585`}
          x1="8.80896"
          y1="25.707"
          x2="32.7583"
          y2="25.707"
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="#5EDF60" />
          <stop offset="1" stopColor="#84EE60" />
        </linearGradient>
      </defs>
    </svg>
  );
});
