import React, { SVGAttributes, forwardRef } from 'react';

import { useUniqId } from '@use-platform/react';

export interface IGoodProps extends SVGAttributes<SVGSVGElement> {
  className?: string;
}

export const Good = forwardRef<SVGSVGElement, IGoodProps>((props, ref) => {
  const { className, ...restProps } = props;
  const id = useUniqId();

  return (
    <svg
      width="80"
      height="80"
      viewBox="0 0 149 149"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
      {...restProps}
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <g filter={`url(#${id}a)`}>
        <circle cx="74.01" cy="74.01" r="74.01" fill="#fff" />
      </g>
      <circle cx="74.01" cy="74.01" r="67.51" stroke="#39BA75" strokeWidth="13" />
      <g style={{ mixBlendMode: 'overlay' }} filter={`url(#${id}b)`}>
        <circle cx="74" cy="74" r="74" fill="#000" fillOpacity=".01" />
      </g>
      <path
        d="M55.5 100.5c5.5 0 7.5-3.466 7.5-18C63 70.534 61 68 57.5 68S43 65.5 43 82.5s7 18 12.5 18z"
        fill={`url(#${id}c)`}
      />
      <path
        d="M105 76.5c-2 21.5-3.5 25-23 25s-16.5 1-16.5-30.5c0-8.5 10-9.5 10-15s0-10 4-10 7.5 3 7.5 9c0 4.8-1.667 9.333-2.5 11h11c2.5 0 10.473.045 9.5 10.5z"
        fill={`url(#${id}d)`}
      />
      <g style={{ mixBlendMode: 'overlay' }} filter={`url(#${id}e)`} fill="#000" fillOpacity=".01">
        <path d="M55.5 100.5c5.5 0 7.5-3.466 7.5-18C63 70.534 61 68 57.5 68S43 65.5 43 82.5s7 18 12.5 18zm49.5-24c-2 21.5-3.5 25-23 25s-16.5 1-16.5-30.5c0-8.5 10-9.5 10-15s0-10 4-10 7.5 3 7.5 9c0 .122-.001.243-.003.365C86.909 60.418 90.447 66 95.5 66c2.5 0 10.473.045 9.5 10.5z" />
      </g>
      <defs>
        <filter
          id={`${id}a`}
          x="-1.198"
          y="0"
          width="150.815"
          height="148.02"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feBlend in="SourceGraphic" in2="BackgroundImageFix" result="shape" />
          <feColorMatrix
            in="SourceAlpha"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
            result="hardAlpha"
          />
          <feOffset dx="-1.198" />
          <feGaussianBlur stdDeviation=".998" />
          <feComposite in2="hardAlpha" operator="arithmetic" k2="-1" k3="1" />
          <feColorMatrix values="0 0 0 0 1 0 0 0 0 1 0 0 0 0 1 0 0 0 1 0" />
          <feBlend mode="overlay" in2="shape" result="effect1_innerShadow_0_1029" />
          <feColorMatrix
            in="SourceAlpha"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
            result="hardAlpha"
          />
          <feOffset dx="1.597" />
          <feGaussianBlur stdDeviation=".799" />
          <feComposite in2="hardAlpha" operator="arithmetic" k2="-1" k3="1" />
          <feColorMatrix values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.55 0" />
          <feBlend
            mode="soft-light"
            in2="effect1_innerShadow_0_1029"
            result="effect2_innerShadow_0_1029"
          />
        </filter>
        <filter
          id={`${id}b`}
          x="-.923"
          y="-.582"
          width="149.505"
          height="148.582"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feBlend in="SourceGraphic" in2="BackgroundImageFix" result="shape" />
          <feColorMatrix
            in="SourceAlpha"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
            result="hardAlpha"
          />
          <feOffset dx="-.923" />
          <feGaussianBlur stdDeviation=".769" />
          <feComposite in2="hardAlpha" operator="arithmetic" k2="-1" k3="1" />
          <feColorMatrix values="0 0 0 0 1 0 0 0 0 1 0 0 0 0 1 0 0 0 1 0" />
          <feBlend in2="shape" result="effect1_innerShadow_0_1029" />
          <feColorMatrix
            in="SourceAlpha"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
            result="hardAlpha"
          />
          <feOffset dx=".582" dy="-.582" />
          <feGaussianBlur stdDeviation=".647" />
          <feComposite in2="hardAlpha" operator="arithmetic" k2="-1" k3="1" />
          <feColorMatrix values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.48 0" />
          <feBlend in2="effect1_innerShadow_0_1029" result="effect2_innerShadow_0_1029" />
        </filter>
        <filter
          id={`${id}e`}
          x="42.077"
          y="45.418"
          width="63.587"
          height="56.086"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feBlend in="SourceGraphic" in2="BackgroundImageFix" result="shape" />
          <feColorMatrix
            in="SourceAlpha"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
            result="hardAlpha"
          />
          <feOffset dx="-.923" />
          <feGaussianBlur stdDeviation=".769" />
          <feComposite in2="hardAlpha" operator="arithmetic" k2="-1" k3="1" />
          <feColorMatrix values="0 0 0 0 1 0 0 0 0 1 0 0 0 0 1 0 0 0 1 0" />
          <feBlend in2="shape" result="effect1_innerShadow_0_1029" />
          <feColorMatrix
            in="SourceAlpha"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
            result="hardAlpha"
          />
          <feOffset dx=".582" dy="-.582" />
          <feGaussianBlur stdDeviation=".647" />
          <feComposite in2="hardAlpha" operator="arithmetic" k2="-1" k3="1" />
          <feColorMatrix values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.48 0" />
          <feBlend in2="effect1_innerShadow_0_1029" result="effect2_innerShadow_0_1029" />
        </filter>
        <radialGradient
          id={`${id}c`}
          cx="0"
          cy="0"
          r="1"
          gradientUnits="userSpaceOnUse"
          gradientTransform="matrix(46.49965 -72.5002 82.17583 52.70533 43 118.5)"
        >
          <stop stopColor="#1B1D24" />
          <stop offset="1" stopColor="#3F485F" />
        </radialGradient>
        <radialGradient
          id={`${id}d`}
          cx="0"
          cy="0"
          r="1"
          gradientUnits="userSpaceOnUse"
          gradientTransform="matrix(46.49965 -72.5002 82.17583 52.70533 43 118.5)"
        >
          <stop stopColor="#1B1D24" />
          <stop offset="1" stopColor="#3F485F" />
        </radialGradient>
      </defs>
    </svg>
  );
});
