import React, { SVGAttributes, forwardRef } from 'react';

export interface ListProps extends SVGAttributes<SVGSVGElement> {
  /**
   * Additional className for svg root
   */
  className?: string;
  /**
   * Icon size
   *
   * @default 24
   */
  size?: 12 | 16 | 24 | 32;
}

export const List = forwardRef<SVGSVGElement, ListProps>((props, ref) => {
  const { className, size = 24, ...otherProps } = props;

  return (
    <svg
      width={size}
      height={size}
      viewBox="0 0 24 24"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M3.25 5.75195C2.55964 5.75195 2 6.3116 2 7.00195C2 7.69231 2.55964 8.25195 3.25 8.25195C3.94036 8.25195 4.5 7.69231 4.5 7.00195C4.5 6.3116 3.94036 5.75195 3.25 5.75195ZM7 6.00195C6.44772 6.00195 6 6.44967 6 7.00195C6 7.55424 6.44772 8.00195 7 8.00195H19C19.5523 8.00195 20 7.55424 20 7.00195C20 6.44967 19.5523 6.00195 19 6.00195H7ZM7 11.002C6.44772 11.002 6 11.4497 6 12.002C6 12.5542 6.44772 13.002 7 13.002H21C21.5523 13.002 22 12.5542 22 12.002C22 11.4497 21.5523 11.002 21 11.002H7ZM6 17.002C6 16.4497 6.44772 16.002 7 16.002H17C17.5523 16.002 18 16.4497 18 17.002C18 17.5542 17.5523 18.002 17 18.002H7C6.44771 18.002 6 17.5542 6 17.002ZM2 12.002C2 11.3116 2.55964 10.752 3.25 10.752C3.94036 10.752 4.5 11.3116 4.5 12.002C4.5 12.6923 3.94036 13.252 3.25 13.252C2.55964 13.252 2 12.6923 2 12.002ZM3.25 15.752C2.55964 15.752 2 16.3116 2 17.002C2 17.6923 2.55964 18.252 3.25 18.252C3.94036 18.252 4.5 17.6923 4.5 17.002C4.5 16.3116 3.94036 15.752 3.25 15.752Z"
        fill="#262633"
      />
    </svg>
  );
});
