import React, { SVGAttributes, forwardRef } from 'react';

import { useUniqId } from '@use-platform/react';

export interface PlusIconProps extends SVGAttributes<SVGSVGElement> {
  /**
   * Additional className for svg root
   */
  className?: string;
  /**
   * Icon size
   *
   * @default 24
   */
  size?: 12 | 16 | 24 | 32;
}

export const PlusIcon = forwardRef<SVGSVGElement, PlusIconProps>((props, ref) => {
  const { className, size = 24, ...otherProps } = props;
  const id = useUniqId();

  return (
    <svg
      width={size}
      height={size}
      viewBox="0 0 40 40"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <circle cx="20" cy="20" r="20" fill={`url(#${id}paint0_radial_2_4182)`} />
      <path
        d="M22.6987 6.93997C21.8272 6.76084 20.9247 6.66675 20.0002 6.66675C12.6364 6.66675 6.66687 12.6363 6.66687 20.0001C6.66687 27.3639 12.6364 33.3334 20.0002 33.3334C27.364 33.3334 33.3335 27.3639 33.3335 20.0001C33.3335 19.7661 33.3275 19.5334 33.3156 19.3024H23.6494L21.7743 28.2138H18.2222L20.0973 19.3024H11.7252L12.4312 15.9418H20.8045L22.6987 6.93997Z"
        fill="white"
      />
      <path
        d="M32.7047 15.9418H24.3566L26.008 8.09374C29.1718 9.69332 31.6115 12.5168 32.7047 15.9418Z"
        fill="white"
      />
      <defs>
        <radialGradient
          id={`${id}paint0_radial_2_4182`}
          cx="0"
          cy="0"
          r="1"
          gradientUnits="userSpaceOnUse"
          gradientTransform="translate(-1.25275 7.75862) rotate(31.7233) scale(49.9714 59.3482)"
        >
          <stop offset="0.0520833" stopColor="#48CCE0" />
          <stop offset="0.380208" stopColor="#505ADD" />
          <stop offset="0.682292" stopColor="#BE40C0" />
          <stop offset="0.942708" stopColor="#FBA82B" />
        </radialGradient>
      </defs>
    </svg>
  );
});
