import React, { SVGAttributes, forwardRef } from 'react';

export interface ReceiptProps extends SVGAttributes<SVGSVGElement> {
  /**
   * Additional className for svg root
   */
  className?: string;
  /**
   * Icon size
   *
   * @default 24
   */
  size?: 12 | 16 | 24 | 32;
}

export const Receipt = forwardRef<SVGSVGElement, ReceiptProps>((props, ref) => {
  const { className, size = 24, ...otherProps } = props;

  return (
    <svg
      width={size}
      height={size}
      viewBox="0 0 24 24"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M16.9651 19.4846C18.1799 18.798 19 17.4947 19 16V5C19 4.44772 18.5523 4 18 4H9C8.44772 4 8 4.44772 8 5V16H14C15.1407 16 15.9248 16.9145 16.0536 17.8651C16.1926 18.8902 16.5583 19.2454 16.7359 19.371C16.8261 19.4348 16.9078 19.4677 16.9651 19.4846ZM14.6739 20C14.3915 19.5192 14.1764 18.9059 14.0717 18.1337C14.0643 18.0788 14.0386 18.0357 14.015 18.0128C14.0068 18.0049 14.0009 18.0013 13.9984 18H5C5 19.1043 5.89582 20 7.00068 20H14.6739ZM6 16H5C3.89543 16 3 16.8954 3 18C3 20.2094 4.79184 22 7.00068 22H14.9994C18.313 22 21 19.3139 21 16V5C21 3.34315 19.6569 2 18 2H9C7.34315 2 6 3.34315 6 5V16ZM10 8C10 7.44772 10.4477 7 11 7H16C16.5523 7 17 7.44772 17 8C17 8.55228 16.5523 9 16 9H11C10.4477 9 10 8.55228 10 8ZM11 11C10.4477 11 10 11.4477 10 12C10 12.5523 10.4477 13 11 13H14C14.5523 13 15 12.5523 15 12C15 11.4477 14.5523 11 14 11H11Z"
        fill="currentColor"
      />
    </svg>
  );
});
