import React, { SVGAttributes, forwardRef } from 'react';

export interface ReceiptsProps extends SVGAttributes<SVGSVGElement> {
  /**
   * Additional className for svg root
   */
  className?: string;
  /**
   * Icon size
   *
   * @default 24
   */
  size?: 12 | 16 | 24 | 32;
}

export const Receipts = forwardRef<SVGSVGElement, ReceiptsProps>((props, ref) => {
  const { className, size = 24, ...otherProps } = props;

  return (
    <svg
      width={size}
      height={size}
      viewBox="0 0 24 24"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M8.00001 5C8.00001 3.34315 9.34315 2 11 2H18C19.6569 2 21 3.34315 21 5V15C21 16.6569 19.6569 18 18 18H17V19C17 20.6569 15.6569 22 14 22H6.50001H6.00001C6.00001 22 2.69437 22 2.09321 18.9949C1.98487 18.4534 2.44772 18 3.00001 18H10.7192C11.1781 18 11.5584 18.3264 11.7867 18.7245C12.5182 20 14 20 14 20C14.5523 20 15 19.5523 15 19V9C15 8.45116 14.5504 8 13.9947 8H9.00001H7.00531C6.44958 8 6.00001 8.45116 6.00001 9V16H4.00001V9C4.00001 7.3397 5.35191 6 7.00531 6H8.00001V5ZM18 16H17V9C17 7.3397 15.6481 6 13.9947 6H10V5C10 4.44772 10.4477 4 11 4H18C18.5523 4 19 4.44772 19 5V15C19 15.5523 18.5523 16 18 16ZM9.00001 10C8.44772 10 8.00001 10.4477 8.00001 11C8.00001 11.5523 8.44772 12 9.00001 12H12C12.5523 12 13 11.5523 13 11C13 10.4477 12.5523 10 12 10H9.00001ZM8.00001 14C8.00001 13.4477 8.44772 13 9.00001 13H11C11.5523 13 12 13.4477 12 14C12 14.5523 11.5523 15 11 15H9.00001C8.44772 15 8.00001 14.5523 8.00001 14Z"
        fill="currentColor"
      />
    </svg>
  );
});
