import React, { SVGAttributes, forwardRef } from 'react';

export interface RefundProps extends SVGAttributes<SVGSVGElement> {
  /**
   * Additional className for svg root
   */
  className?: string;
  /**
   * Icon size
   *
   * @default 24
   */
  size?: 12 | 16 | 24 | 32;
}

export const Refund = forwardRef<SVGSVGElement, RefundProps>((props, ref) => {
  const { className, size = 24, ...otherProps } = props;

  return (
    <svg
      width={size}
      height={size}
      viewBox="0 0 16 16"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <circle cx="8" cy="8" r="8" fill="#00A85A" />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M8.943 3.724c.52.52.52 1.365 0 1.886l-.568.567L7.2 7l2.39-.332h1.744a1.333 1.333 0 1 1 0 2.667h-1.98l-2.154-.3 1.286.898.458.459a1.333 1.333 0 1 1-1.886 1.885L3.724 8.943a1.333 1.333 0 0 1 0-1.886l3.333-3.333c.52-.52 1.365-.52 1.886 0z"
        fill="#fff"
      />
    </svg>
  );
});
