import React, { SVGAttributes, forwardRef } from 'react';

export interface RejectProps extends SVGAttributes<SVGSVGElement> {
  /**
   * Additional className for svg root
   */
  className?: string;
  /**
   * Icon size
   *
   * @default 24
   */
  size?: 12 | 16 | 24 | 32;
}

export const Reject = forwardRef<SVGSVGElement, RejectProps>((props, ref) => {
  const { className, size = 24, ...otherProps } = props;

  return (
    <svg
      width={size}
      height={size}
      viewBox="0 0 16 16"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <circle cx="8" cy="8" r="8" fill="#F33" />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M4.387 9.728a1.333 1.333 0 0 0 1.887 1.885l1.724-1.726 1.725 1.727a1.333 1.333 0 0 0 1.886-1.885L9.882 8.001l1.726-1.727A1.333 1.333 0 1 0 9.72 4.389L7.998 6.114 6.275 4.39A1.333 1.333 0 1 0 4.39 6.275l1.724 1.726-1.726 1.727z"
        fill="#fff"
      />
    </svg>
  );
});
