import React, { SVGAttributes, forwardRef } from 'react';

export interface SbpProps extends SVGAttributes<SVGSVGElement> {
  /**
   * Additional className for svg root
   */
  className?: string;
}

export const Sbp = forwardRef<SVGSVGElement, SbpProps>((props, ref) => {
  const { className, width, height, ...otherProps } = props;

  return (
    <svg
      width={width}
      height={height}
      viewBox="0 0 36 24"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M16.8616 12.9958L19.3108 14.6062L19.3107 17.5937L16.8503 21.9999L16.8616 12.9958Z"
        fill="#62B22F"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M14.8307 11.7238L17.2744 13.1398L10.0198 17.5457L12.3877 13.2361L14.8307 11.7238Z"
        fill="#974995"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M26.226 7.6523L21.5572 7.62901L19.3086 6.27715L16.8645 2L26.226 7.6523Z"
        fill="#EE7024"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M16.8644 2L19.3085 6.27715L19.3134 12.1708L16.8496 11.4179L16.8644 2Z"
        fill="#FBB61B"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M10 6.30322L12.3954 10.658L12.3876 13.2361L10.0198 17.5457L10 6.30322Z"
        fill="#5A58A3"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M10 6.30322L26.1892 16.2087L21.5501 16.2411L12.3954 10.658L10 6.30322Z"
        fill="#2188CB"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M21.5572 7.62903L26.226 7.65231L19.3156 11.9005L19.3086 8.99924L21.5572 7.62903Z"
        fill="#DA0954"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M19.3107 17.5938L21.5501 16.2412L26.1892 16.2087L16.8503 22L19.3107 17.5938Z"
        fill="#037F37"
      />
    </svg>
  );
});
