import React, { SVGAttributes, forwardRef } from 'react';

export interface IMarketProps extends SVGAttributes<SVGSVGElement> {
  className?: string;
  size?: 12 | 16 | 24 | 32;
}

export const Market = forwardRef<SVGSVGElement, IMarketProps>((props, ref) => {
  const { className, size = 12, ...restProps } = props;

  return (
    <svg
      className={`SvgIcon${className ? ` ${className}` : ''}`}
      width={size}
      height={size}
      viewBox="0 0 24 25"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
      ref={ref}
      {...restProps}
    >
      <circle cx="12" cy="12.002" r="12" fill="url(#paint0_linear_3749_42350)" />
      <path
        d="M22.9869 16.8353C23.6356 15.3629 23.997 13.7354 24.0001 12.0239V11.98C23.9987 11.2051 23.9238 10.4474 23.7821 9.71359C22.0988 12.2274 20.4854 13.9884 19.6293 13.7506C18.128 13.3335 19.4811 8.48018 20.3537 5.35018L20.3673 5.30147L15.487 3.65332L9.68586 13.1924L10.466 8.03183L6.1154 6.53163L0.216553 14.2827C0.530931 15.9166 1.17669 17.4325 2.08114 18.7579L6.29542 13.1924L5.51532 18.8633L9.92591 20.3635L15.1673 11.7937C14.9142 13.415 14.4967 17.0859 18.0732 18.1665C19.8011 18.6885 21.4575 18.0769 22.9869 16.8353Z"
        fill="url(#paint1_linear_3749_42350)"
      />
      <defs>
        <linearGradient
          id="paint0_linear_3749_42350"
          x1="12"
          y1="-5.70906"
          x2="12"
          y2="26.2801"
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="#FFE55B" />
          <stop offset="1" stopColor="#FFCC00" />
        </linearGradient>
        <linearGradient
          id="paint1_linear_3749_42350"
          x1="12.1083"
          y1="-0.241821"
          x2="12.1083"
          y2="20.3635"
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="#3E3F3A" />
          <stop offset="1" />
        </linearGradient>
      </defs>
    </svg>
  );
});
