import React, { SVGAttributes, forwardRef } from 'react';

export interface IQProps extends SVGAttributes<SVGSVGElement> {
  className?: string;
  size?: 12 | 16 | 24 | 32;
}

export const Q = forwardRef<SVGSVGElement, IQProps>((props, ref) => {
  const { className, size = 12, ...restProps } = props;

  return (
    <svg
      className={`SvgIcon${className ? ` ${className}` : ''}`}
      width={size}
      height={size}
      viewBox="0 0 24 25"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
      ref={ref}
      {...restProps}
    >
      <path
        d="M0 12.002C0 5.37454 5.37258 0.00195312 12 0.00195312C18.6274 0.00195312 24 5.37454 24 12.002C24 18.6294 18.6274 24.002 12 24.002C5.37258 24.002 0 18.6294 0 12.002Z"
        fill="#2B304C"
      />
      <path
        d="M10.7273 6.00195C9.58435 6.10489 8.51215 6.60808 7.69435 7.42535C7.36666 7.75694 7.1071 8.15129 6.93071 8.58554C6.75432 9.01978 6.66463 9.48527 6.66683 9.95499V10.7545C6.66376 11.219 6.75097 11.6794 6.92347 12.1096C7.09596 12.5398 7.35036 12.9311 7.67208 13.2613C8.49222 14.0959 9.57613 14.61 10.7329 14.7129C10.8731 14.7239 11.018 14.7346 11.1585 14.7355C11.1465 14.7322 10.7273 14.1524 10.7273 14.1524L10.7273 6.00195Z"
        fill="#F6F2E9"
      />
      <path
        d="M16.8378 17.9875V9.97752C16.8405 9.04182 16.4791 8.14292 15.8323 7.47639C15.0122 6.64154 13.9283 6.12735 12.7715 6.02446C12.6315 6.01378 12.4864 6.00306 12.3458 6.00219L12.777 6.59484V16.5721C12.777 17.1281 12.9946 17.6614 13.3818 18.0546C13.769 18.4477 14.2942 18.6686 14.8419 18.6686H17.3334L16.8378 17.9875Z"
        fill="#F6F2E9"
      />
    </svg>
  );
});
