import React, { SVGAttributes, forwardRef } from 'react';

export interface AppleProps extends SVGAttributes<SVGSVGElement> {
  /**
   * Additional className for svg root
   */
  className?: string;
  /**
   * Icon size
   *
   * @default 24
   */
  size?: 12 | 16 | 24 | 32 | 36 | 64;
}

export const Apple = forwardRef<SVGSVGElement, AppleProps>((props, ref) => {
  const { className, size = 36, ...otherProps } = props;

  return (
    <svg
      width={size}
      height={size}
      viewBox="0 0 36 36"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path
        d="M30.5744 24.5481C30.1031 25.6486 29.5452 26.6616 28.8989 27.593C28.0178 28.8626 27.2965 29.7415 26.7405 30.2296C25.8787 31.0306 24.9554 31.4409 23.9666 31.4642C23.2568 31.4642 22.4008 31.2601 21.4044 30.8459C20.4046 30.4337 19.4859 30.2296 18.6459 30.2296C17.7648 30.2296 16.8199 30.4337 15.8093 30.8459C14.797 31.2601 13.9816 31.4759 13.3582 31.4973C12.41 31.5381 11.4649 31.1162 10.5216 30.2296C9.91945 29.6987 9.16635 28.7888 8.26416 27.4996C7.29618 26.123 6.50037 24.5267 5.87692 22.7067C5.20923 20.741 4.87451 18.8374 4.87451 16.9945C4.87451 14.8835 5.3258 13.0628 6.22972 11.537C6.94012 10.3115 7.8852 9.34472 9.06805 8.63502C10.2509 7.92532 11.529 7.56366 12.9053 7.54052C13.6584 7.54052 14.646 7.77599 15.8733 8.23875C17.0971 8.70307 17.8829 8.93854 18.2275 8.93854C18.485 8.93854 19.358 8.66321 20.8378 8.11431C22.2373 7.60527 23.4184 7.3945 24.386 7.47753C27.0079 7.69141 28.9777 8.73613 30.2877 10.6183C27.9428 12.0544 26.7829 14.0659 26.8059 16.6463C26.8271 18.6562 27.5485 20.3287 28.9662 21.6568C29.6087 22.2731 30.3262 22.7495 31.1245 23.0878C30.9514 23.5953 30.7686 24.0814 30.5744 24.5481ZM24.5611 0.630179C24.5611 2.20554 23.9917 3.67645 22.8567 5.0379C21.4871 6.65641 19.8304 7.59166 18.0339 7.44408C18.0111 7.25509 17.9978 7.05618 17.9978 6.84716C17.9978 5.33481 18.6491 3.71631 19.8058 2.39296C20.3833 1.72292 21.1177 1.1658 22.0084 0.72137C22.8971 0.283572 23.7377 0.0414606 24.5283 0C24.5514 0.210601 24.5611 0.421215 24.5611 0.630159V0.630179Z"
        fill="currentColor"
      />
    </svg>
  );
});
