import React, { SVGAttributes, forwardRef } from 'react';

export interface EsiaProps extends SVGAttributes<SVGSVGElement> {
  /**
   * Additional className for svg root
   */
  className?: string;
  /**
   * Icon size
   *
   * @default 24
   */
  size?: 12 | 16 | 24 | 32 | 36 | 64;
}

export const Esia = forwardRef<SVGSVGElement, EsiaProps>((props, ref) => {
  const { className, size = 36, ...otherProps } = props;

  return (
    <svg
      width={size}
      height={size}
      viewBox="0 0 36 36"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path
        d="M18 33C26.2843 33 33 26.2844 33 18C33 9.71569 26.2843 3 18 3C9.71574 3 3 9.71569 3 18C3 26.2844 9.71574 33 18 33Z"
        fill="#EE2F53"
      />
      <path
        d="M16.7299 28.1398C17.3179 28.3887 17.9516 28.5114 18.5899 28.4999C19.2283 28.5114 19.862 28.3887 20.4499 28.1398C20.4575 28.1352 20.4952 28.1169 20.5589 28.086C20.913 27.9137 22.0705 27.3508 23.3499 26.5799C24.86 25.6698 26.0899 24.7299 26.0899 24.7299C27.0862 23.8792 27.74 22.696 27.9299 21.3999C27.9399 21.3398 28.0899 19.8098 28.0899 17.9999C28.0899 16.4685 27.9754 15.1375 27.9401 14.7277C27.9337 14.6531 27.9299 14.6091 27.9299 14.5998C27.74 13.3036 27.0862 12.1205 26.0899 11.2698C26.0659 11.2592 25.9681 11.1875 25.8089 11.0708C25.3707 10.7495 24.4675 10.0873 23.36 9.41981C21.8499 8.50977 20.5199 7.85977 20.46 7.85977C19.269 7.38398 17.9409 7.38398 16.7499 7.85977C16.7423 7.86435 16.7046 7.88269 16.6407 7.91372C16.2867 8.08591 15.1293 8.64875 13.8499 9.41981C12.3399 10.3299 11.11 11.2698 11.11 11.2698C10.6626 11.6306 10.2862 12.0715 9.99991 12.5698L10.8399 13.0598C11.0645 12.6777 11.3558 12.3391 11.6999 12.0598C11.71 12.0498 12.8799 11.1598 14.3299 10.2799C15.7799 9.39984 17.1299 8.76981 17.1299 8.76981C18.0536 8.41479 19.0761 8.41479 19.9999 8.76981C19.9999 8.76981 21.3999 9.36981 22.86 10.2498C24.3199 11.1299 25.51 12.0398 25.51 12.0398C26.2867 12.7235 26.7998 13.6574 26.96 14.6799C26.9699 14.6898 27.1199 16.2198 27.1199 17.9799C27.1199 19.7398 26.96 21.2799 26.96 21.2799C26.8006 22.3024 26.2874 23.2367 25.51 23.9198C25.4999 23.9299 24.3199 24.8299 22.86 25.7098C21.3999 26.5898 20.0499 27.2198 20.0499 27.2198C19.1261 27.5749 18.1036 27.5749 17.1799 27.2199L17.1662 27.2133C17.0202 27.1441 15.7534 26.5437 14.3699 25.7098C12.91 24.8299 11.7199 23.9198 11.7199 23.9198C11.3755 23.6408 11.0842 23.3021 10.86 22.9198L9.99991 23.4299C10.2806 23.9262 10.6501 24.3668 11.0899 24.7299C11.1399 24.7698 12.3299 25.6698 13.8299 26.5799C15.3299 27.4898 16.6699 28.1398 16.7299 28.1398Z"
        fill="white"
      />
      <path d="M11 15L7 15L7 21L8 21L8 16L11 16L11 15Z" fill="white" />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M12.0001 18C12.0001 16.3432 13.3433 15 15.0001 15C16.657 15 18.0001 16.3432 18.0001 18C18.0001 19.6568 16.657 21 15.0001 21C13.3433 21 12.0001 19.6568 12.0001 18ZM17.0001 18C17.0001 16.8954 16.1046 16 15.0001 16C13.8955 16 13.0001 16.8954 13.0001 18C13.0001 19.1046 13.8955 20 15.0001 20C16.1046 20 17.0001 19.1046 17.0001 18Z"
        fill="white"
      />
      <path
        d="M19.1456 18.903C19.5388 20.1489 20.6933 20.9971 21.9997 21C22.7053 21.0009 23.3887 20.753 23.9296 20.3L23.2897 19.53C22.6136 20.0992 21.644 20.1571 20.905 19.6725C20.1659 19.1879 19.8325 18.2757 20.085 17.4287C20.3375 16.5817 21.1159 16.0009 21.9997 16C22.4359 15.9978 22.8608 16.1383 23.2097 16.4L23.8197 15.61C22.7789 14.8203 21.3466 14.7951 20.2786 15.5475C19.2106 16.3 18.7523 17.6571 19.1456 18.903Z"
        fill="white"
      />
    </svg>
  );
});
