import React, { SVGAttributes, forwardRef } from 'react';

export interface FacebookProps extends SVGAttributes<SVGSVGElement> {
  /**
   * Additional className for svg root
   */
  className?: string;
  /**
   * Icon size
   *
   * @default 24
   */
  size?: 12 | 16 | 24 | 32 | 36 | 64;
}

export const Facebook = forwardRef<SVGSVGElement, FacebookProps>((props, ref) => {
  const { className, size = 36, ...otherProps } = props;

  return (
    <svg
      width={size}
      height={size}
      viewBox="0 0 36 36"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M18 2.98193C26.2843 2.98193 33 9.69766 33 17.9819C33 25.4688 27.5147 31.6744 20.3438 32.7997V22.3179H23.8387L23.8387 22.3179H23.8389L24.5039 17.9819H20.3438V15.1694C20.3438 14.8947 20.3749 14.6216 20.4458 14.3642C20.6815 13.5093 21.3562 12.8257 22.7881 12.8257H24.6795V12.8257H24.6797V9.13428C24.6797 9.13428 22.9626 8.84131 21.322 8.84131C21.0008 8.84131 20.69 8.85956 20.3905 8.89574C19.9763 8.94577 19.5838 9.03008 19.2151 9.14782C17.0068 9.85305 15.6561 11.7577 15.6561 14.6773V17.9819H11.8477V17.982H11.8475V22.3179H15.6561V32.7997C8.48518 31.6743 3 25.4687 3 17.9819C3 9.69766 9.71572 2.98193 18 2.98193Z"
        fill="#1877F2"
      />
    </svg>
  );
});
