import React, { SVGAttributes, forwardRef } from 'react';

export interface GoogleProps extends SVGAttributes<SVGSVGElement> {
  /**
   * Additional className for svg root
   */
  className?: string;
  /**
   * Icon size
   *
   * @default 24
   */
  size?: 12 | 16 | 24 | 32 | 36 | 64;
}

export const Google = forwardRef<SVGSVGElement, GoogleProps>((props, ref) => {
  const { className, size = 36, ...otherProps } = props;

  return (
    <svg
      width={size}
      height={size}
      viewBox="0 0 36 36"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path
        d="M9.64823 21.1294L8.60396 25.0278L4.78717 25.1086C3.64651 22.9929 2.99951 20.5723 2.99951 18C2.99951 15.5126 3.60444 13.167 4.67672 11.1016H4.67754L8.07555 11.7245L9.56409 15.1022C9.25254 16.0104 9.08274 16.9854 9.08274 18C9.08285 19.1011 9.28231 20.1561 9.64823 21.1294Z"
        fill="#FBBB00"
      />
      <path
        d="M32.7379 15.1978C32.9102 16.1051 33 17.0422 33 18C33 19.0739 32.8871 20.1214 32.672 21.1319C31.9418 24.5704 30.0338 27.5729 27.3906 29.6977L27.3898 29.6968L23.1098 29.4785L22.5041 25.6971C24.2579 24.6685 25.6286 23.0588 26.3506 21.1319H18.3296V15.1978H26.4676H32.7379Z"
        fill="#518EF8"
      />
      <path
        d="M27.3891 29.6968L27.3899 29.6976C24.8193 31.7638 21.5539 33.0001 17.9992 33.0001C12.2867 33.0001 7.32019 29.8072 4.78662 25.1085L9.64768 21.1294C10.9144 24.5102 14.1757 26.9168 17.9992 26.9168C19.6426 26.9168 21.1822 26.4726 22.5033 25.697L27.3891 29.6968Z"
        fill="#28B446"
      />
      <path
        d="M27.5743 6.45333L22.7149 10.4317C21.3476 9.577 19.7313 9.08328 17.9997 9.08328C14.0898 9.08328 10.7675 11.6003 9.56419 15.1023L4.67758 11.1017H4.67676C7.17324 6.2885 12.2024 3 17.9997 3C21.6393 3 24.9765 4.29646 27.5743 6.45333Z"
        fill="#F14336"
      />
    </svg>
  );
});
