import React, { SVGAttributes, forwardRef } from 'react';

export interface MailProps extends SVGAttributes<SVGSVGElement> {
  /**
   * Additional className for svg root
   */
  className?: string;
  /**
   * Icon size
   *
   * @default 24
   */
  size?: 12 | 16 | 24 | 32 | 36 | 64;
}

export const Mail = forwardRef<SVGSVGElement, MailProps>((props, ref) => {
  const { className, size = 36, ...otherProps } = props;

  return (
    <svg
      width={size}
      height={size}
      viewBox="0 0 36 36"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M18.0003 3.00049C9.72818 3.00049 3.00049 9.72817 3.00049 18.0003C3.00049 26.272 9.7276 32.9995 17.9992 33C21.0155 33.0049 23.9626 32.0954 26.4513 30.3912L27.0805 29.9382L24.3133 26.7189L23.8053 27.049L23.804 27.0499C22.0738 28.1644 20.0583 28.7563 18.0003 28.7544C12.0714 28.7544 7.24608 23.9291 7.24608 18.0003C7.24608 12.0714 12.0714 7.24608 18.0003 7.24608C18.9176 7.24608 19.8086 7.3616 20.6593 7.57886C25.162 8.72874 28.5383 12.7284 28.7445 17.5339C28.7511 17.6885 28.7545 17.844 28.7545 18.0003C28.7545 18.764 28.6695 19.5404 28.5034 20.3049C28.3539 20.9103 28.0837 21.2507 27.8243 21.4385C27.5572 21.6319 27.26 21.694 27.0145 21.6752C26.7483 21.6532 26.4744 21.5474 26.2727 21.3519C26.0833 21.1682 25.9119 20.862 25.9091 20.339V17.9995C25.9068 15.9029 25.0729 13.8927 23.5904 12.4102C22.1078 10.9276 20.0977 10.0937 18.001 10.0914L17.9996 10.0914C15.9029 10.0937 13.8928 10.9276 12.4102 12.4102C10.9276 13.8927 10.0937 15.9029 10.0914 17.9995V18.001C10.0937 20.0976 10.9276 22.1078 12.4102 23.5903C13.8928 25.0729 15.9036 25.9068 18.0003 25.9091C19.8675 25.9091 21.6334 25.2659 23.0505 24.0832C23.4681 24.567 23.971 24.9732 24.5362 25.2803C25.327 25.71 26.2138 25.9318 27.1137 25.9251C28.3018 25.9245 29.4728 25.5276 30.42 24.8099C31.3973 24.0665 32.1129 23.0044 32.5047 21.7552L32.5063 21.7499C32.539 21.6426 32.5821 21.4789 32.6147 21.3517C32.6316 21.2859 32.6467 21.2259 32.6577 21.1817L32.671 21.1275L32.6755 21.1086L32.6782 21.0969L32.6813 21.0824L32.6822 21.078L32.6826 21.0758C32.9047 20.1129 33.0001 19.1562 33.0001 18.0003C33.0001 9.72817 26.2724 3.00049 18.0003 3.00049ZM20.5892 20.5892C21.2759 19.9025 21.6623 18.9714 21.6636 18.0003C21.6623 17.0291 21.2759 16.0981 20.5892 15.4113C19.9025 14.7246 18.9714 14.3382 18.0003 14.337C17.0291 14.3382 16.0981 14.7246 15.4113 15.4113C14.7246 16.0981 14.3383 17.0291 14.337 18.0003C14.3383 18.9714 14.7246 19.9025 15.4113 20.5892C16.0981 21.2759 17.0291 21.6623 18.0003 21.6635C18.9714 21.6623 19.9025 21.2759 20.5892 20.5892Z"
        fill="#1877F2"
      />
    </svg>
  );
});
