import React, { SVGAttributes, forwardRef } from 'react';

export interface OkProps extends SVGAttributes<SVGSVGElement> {
  /**
   * Additional className for svg root
   */
  className?: string;
  /**
   * Icon size
   *
   * @default 24
   */
  size?: 12 | 16 | 24 | 32 | 36 | 64;
}

export const Ok = forwardRef<SVGSVGElement, OkProps>((props, ref) => {
  const { className, size = 36, ...otherProps } = props;

  return (
    <svg
      width={size}
      height={size}
      viewBox="0 0 36 36"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path
        d="M18.0014 7.53822C18.8509 7.5393 19.6654 7.87727 20.2661 8.47801C20.8669 9.07875 21.2048 9.89322 21.2059 10.7428C21.2048 11.5924 20.8669 12.4068 20.2661 13.0076C19.6654 13.6083 18.8509 13.9463 18.0014 13.9474C17.1518 13.9463 16.3373 13.6083 15.7366 13.0076C15.1358 12.4068 14.7979 11.5924 14.7968 10.7428C14.7979 9.89345 15.1357 9.07919 15.7361 8.47849C16.3365 7.87779 17.1507 7.53966 18 7.53822H18.0014ZM18.0014 18.4829C20.0538 18.481 22.0218 17.6651 23.4734 16.214C24.925 14.7629 25.7416 12.7953 25.7441 10.7428C25.742 8.68994 24.9255 6.72179 23.4739 5.2702C22.0224 3.81862 20.0542 3.00217 18.0014 3C15.9485 3.00217 13.9804 3.81862 12.5288 5.2702C11.0772 6.72179 10.2607 8.68994 10.2586 10.7428C10.2611 12.7953 11.0778 14.7629 12.5293 16.214C13.9809 17.6651 15.9489 18.481 18.0014 18.4829ZM21.1337 24.7979C22.7265 24.4352 24.2466 23.8059 25.6296 22.9365C26.1388 22.6161 26.4999 22.1065 26.6334 21.5198C26.7669 20.9332 26.6619 20.3175 26.3414 19.8083C26.021 19.2991 25.5114 18.938 24.9247 18.8045C24.3381 18.671 23.7224 18.7761 23.2132 19.0965C21.6504 20.0735 19.8444 20.5916 18.0014 20.5916C16.1583 20.5916 14.3523 20.0735 12.7895 19.0965C12.4098 18.8563 11.9673 18.7344 11.5182 18.7462C11.0691 18.7581 10.6337 18.9031 10.2672 19.1629C9.90066 19.4228 9.61964 19.7856 9.45981 20.2055C9.29997 20.6254 9.26853 21.0833 9.36947 21.5211C9.50311 22.1074 9.86448 22.6161 10.3731 22.9365C11.7559 23.8055 13.2754 24.4348 14.8677 24.7979L10.5408 29.1275C10.1331 29.5565 9.90918 30.1279 9.91679 30.7197C9.92439 31.3116 10.1629 31.877 10.5815 32.2954C11.0002 32.7139 11.5657 32.9522 12.1575 32.9595C12.7494 32.9669 13.3206 32.7427 13.7495 32.3348L18.0027 28.0816L22.2573 32.3361C22.5206 32.6007 22.8452 32.796 23.2023 32.9048C23.5593 33.0135 23.9377 33.0323 24.3038 32.9594C24.6699 32.8865 25.0122 32.7242 25.3004 32.487C25.5886 32.2498 25.8136 31.945 25.9555 31.5998C26.1271 31.1854 26.172 30.7295 26.0844 30.2896C25.9967 29.8497 25.7806 29.4458 25.4632 29.1288L21.135 24.7979H21.1337Z"
        fill="#FF8A00"
      />
    </svg>
  );
});
