import { SVGAttributes, forwardRef } from 'react';

import { Apple } from './Apple';
import { Esia } from './Esia';
import { Facebook } from './Facebook';
import { Google } from './Google';
import { Mail } from './Mail';
import { Ok } from './Ok';
import { Twitter } from './Twitter';
import { Vk } from './Vk';

const SOCIAL_MAP = {
  apple: Apple,
  esia: Esia,
  facebook: Facebook,
  google: Google,
  mail: Mail,
  ok: Ok,
  twitter: Twitter,
  vk: Vk,
};

export type SocialName = keyof typeof SOCIAL_MAP;

export interface SocialProps extends SVGAttributes<SVGSVGElement> {
  /**
   * Additional className for svg root
   */
  className?: string;
  /**
   * Icon size
   *
   * @default 24
   */
  size?: 12 | 16 | 24 | 32 | 36 | 64;

  name: SocialName;
}

export const Social = forwardRef<SVGSVGElement, SocialProps>((props, ref) => {
  const { name, ...otherProps } = props;

  const Icon = SOCIAL_MAP[name];

  return <Icon ref={ref} {...otherProps} />;
});
