import React, { SVGAttributes, forwardRef } from 'react';

export interface TwitterProps extends SVGAttributes<SVGSVGElement> {
  /**
   * Additional className for svg root
   */
  className?: string;
  /**
   * Icon size
   *
   * @default 24
   */
  size?: 12 | 16 | 24 | 32 | 36 | 64;
}

export const Twitter = forwardRef<SVGSVGElement, TwitterProps>((props, ref) => {
  const { className, size = 36, ...otherProps } = props;

  return (
    <svg
      width={size}
      height={size}
      viewBox="0 0 36 36"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path
        d="M12.7656 29.2415C23.9041 29.2415 29.9959 20.0141 29.9959 12.0111C29.9959 11.7485 29.9959 11.4885 29.9783 11.2285C31.1638 10.371 32.187 9.30925 33.0002 8.09293C31.8948 8.58282 30.7221 8.90407 29.5213 9.04597C30.7858 8.28951 31.7323 7.09938 32.1848 5.69709C30.9957 6.40236 29.6949 6.89928 28.3385 7.16641C27.4255 6.19525 26.2178 5.55213 24.9024 5.3366C23.5869 5.12108 22.2371 5.34516 21.0619 5.97417C19.8867 6.60318 18.9516 7.60204 18.4013 8.81613C17.851 10.0302 17.7163 11.3918 18.018 12.6902C15.6103 12.5694 13.255 11.9436 11.1049 10.8534C8.95482 9.76325 7.05802 8.23311 5.53765 6.36232C4.76289 7.69553 4.52546 9.27393 4.87373 10.7761C5.222 12.2782 6.12977 13.5911 7.41216 14.4473C6.44868 14.4189 5.50617 14.1591 4.66414 13.69V13.7657C4.66438 15.1641 5.14832 16.5193 6.03387 17.6016C6.91942 18.6839 8.15206 19.4265 9.52272 19.7036C8.63082 19.9467 7.69504 19.9821 6.78732 19.8071C7.17429 21.0106 7.92783 22.0631 8.94249 22.8172C9.95715 23.5714 11.1822 23.9895 12.4462 24.013C11.1905 24.9998 9.75266 25.7293 8.21483 26.1599C6.677 26.5905 5.06938 26.7137 3.48389 26.5225C6.25316 28.2994 9.47523 29.242 12.7656 29.2377"
        fill="#27ABF5"
      />
    </svg>
  );
});
