import React, { SVGAttributes, forwardRef } from 'react';

export interface VkProps extends SVGAttributes<SVGSVGElement> {
  /**
   * Additional className for svg root
   */
  className?: string;
  /**
   * Icon size
   *
   * @default 24
   */
  size?: 12 | 16 | 24 | 32 | 36 | 64;
}

export const Vk = forwardRef<SVGSVGElement, VkProps>((props, ref) => {
  const { className, size = 36, ...otherProps } = props;

  return (
    <svg
      width={size}
      height={size}
      viewBox="0 0 36 36"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path
        d="M3 17.4C3 10.6118 3 7.21766 5.10883 5.10883C7.21766 3 10.6118 3 17.4 3H18.6C25.3883 3 28.7823 3 30.8912 5.10883C33 7.21766 33 10.6118 33 17.4V18.6C33 25.3883 33 28.7823 30.8912 30.8912C28.7823 33 25.3883 33 18.6 33H17.4C10.6118 33 7.21766 33 5.10883 30.8912C3 28.7823 3 25.3883 3 18.6V17.4Z"
        fill="#0077FF"
      />
      <path
        d="M18.9624 24.6125C12.1249 24.6125 8.225 19.925 8.0625 12.125H11.4875C11.6 17.85 14.1249 20.275 16.1249 20.775V12.125H19.3501V17.0625C21.3251 16.85 23.3998 14.6 24.0998 12.125H27.3249C26.7874 15.175 24.5374 17.425 22.9374 18.35C24.5374 19.1 27.1 21.0625 28.075 24.6125H24.5249C23.7624 22.2375 21.8626 20.4 19.3501 20.15V24.6125H18.9624Z"
        fill="white"
      />
    </svg>
  );
});
