import { FC } from 'react';

import { ApolloSsrContext } from './context';
import { ApolloClient } from './types';

export interface ApolloSsrProviderProps {
  client: ApolloClient;
}

export const ApolloSsrProvider: FC<ApolloSsrProviderProps> = (props) => {
  const { client, children } = props;

  return <ApolloSsrContext.Provider value={client}>{children}</ApolloSsrContext.Provider>;
};
