import { ApolloClient, InMemoryCache } from '@apollo/client';
import { TypedTypePolicies } from '@client/shared/api/graphql';
import { canUseDom } from '@client/shared/libs/can-use-dom';

import generatedIntrospection from './generated-introspection';
import { ApolloLink, NormalizedCacheObject } from './types';

const TYPE_POLICIES: TypedTypePolicies = {
  Account: {
    fields: {
      emails: {
        merge: (_existing, incoming) => incoming,
      },
    },
  },
  Address: {
    merge: (_existing, incoming) => incoming,
  },
  Email: { keyFields: ['address'] },
  Question: { keyFields: [] },
};

export interface BaseClientOptions {
  link: ApolloLink;
  initialState?: NormalizedCacheObject;
}

export function createBaseClient(options: BaseClientOptions) {
  const { link, initialState } = options;

  const client = new ApolloClient({
    ssrMode: !canUseDom,
    link,
    cache: new InMemoryCache({
      typePolicies: TYPE_POLICIES,
      possibleTypes: generatedIntrospection.possibleTypes,
    }),
  });

  if (initialState) {
    client.restore(initialState);
  }

  return client;
}
