import { from } from '@apollo/client';
import { BatchHttpLink } from '@apollo/client/link/batch-http';
import { setContext } from '@apollo/client/link/context';
import { onError } from '@apollo/client/link/error';
import { logError } from '@client/shared/libs/rum';
import { getServerSideProps } from '@client/shared/next';

import { BaseClientOptions, createBaseClient } from './create-base-client';

export type HttpClientOptions = Omit<BaseClientOptions, 'link'>;

export function createHttpClient(options: HttpClientOptions = {}) {
  const { initialState } = options;

  const authLink = setContext(() => {
    const props = getServerSideProps();

    return {
      headers: {
        'x-csrf-token': props?.secretKey,
      },
    };
  });

  const batchHttpLink = new BatchHttpLink({
    uri: '/security/graphql',
    batchMax: 5,
    batchInterval: 20,
  });

  const errorLink = onError((error) => {
    if (error.graphQLErrors) {
      error.graphQLErrors.forEach((error) => {
        logError(error.message, error);
      });
    }
  });

  const client = createBaseClient({
    link: from([authLink, errorLink, batchHttpLink]),
    initialState,
  });

  return client;
}
