import { GraphQLSchema } from 'graphql';

import { SchemaLink } from '@apollo/client/link/schema';

import { BaseClientOptions, createBaseClient } from './create-base-client';

export interface SchemaClientOptions extends Omit<BaseClientOptions, 'link'> {
  schema: GraphQLSchema;
}

export function createSchemaClient(options: SchemaClientOptions) {
  const { schema, initialState } = options;

  const link = new SchemaLink({ schema });

  return createBaseClient({ link, initialState });
}
