import { canUseDom } from '@client/shared/libs/can-use-dom';

import { HttpClientOptions, createHttpClient } from './create-http-client';
import { ApolloClient } from './types';

let APOLLO_CLIENT: ApolloClient | null = null;

export function getOrCreateClient(options?: HttpClientOptions) {
  if (canUseDom && APOLLO_CLIENT) {
    return APOLLO_CLIENT;
  }

  const client = createHttpClient(options);

  if (canUseDom) {
    APOLLO_CLIENT = client;
  }

  return client;
}
