import { useContext } from 'react';

import { ApolloSsrContext } from './context';
import { getOrCreateClient } from './get-or-create-client';
import { NormalizedCacheObject } from './types';

export interface UseApolloClientProps {
  initialState?: NormalizedCacheObject;
}

export function useApolloClient(props: UseApolloClientProps = {}) {
  const client = useContext(ApolloSsrContext);

  if (!client) {
    return getOrCreateClient(props);
  }

  return client;
}
