import type { Banner, Group } from './types';

export type BannerGroupConfig = Pick<Group, 'display' | 'key'>;

export function createBannerGroup(config: BannerGroupConfig): Group {
  return {
    key: config.key,
    display: config.display,
    banners: [],
  };
}

export interface BannerConfig extends Omit<Banner, 'weight'> {
  weight?: number;
}

export function createBanner(config: BannerConfig): Banner {
  return {
    id: config.id,
    value: config.value,
    weight: config.weight ?? 1,
  };
}
