export interface Weightable {
  weight: number;
}

export function getRandomByWeight<T extends Weightable>(values: T[]): T | null {
  let result = null;
  let threshold = 0;

  const totalWeights = values.reduce((weight, value) => weight + value.weight, 0);
  const randomValue = rand(0, totalWeights);

  for (const value of values) {
    threshold += value.weight;

    if (threshold >= randomValue) {
      result = value;
      break;
    }
  }

  return result;
}

function rand(min: number, max: number): number {
  const value = min + Math.random() * (max + 1 - min);

  return Math.floor(value);
}
