import { useStore } from 'effector-react';
import { useEffect } from 'react';

import type { BannerSystemSpec } from './banner-system';
import type { Group } from './types';

export function useBanner(system: BannerSystemSpec, data: Group | null) {
  const value = useStore(system.$value);

  useEffect(() => {
    if (data !== null) {
      system.set(data);
    }
  }, [system, data]);

  return value;
}
