import Head from 'next/head';
import { FC } from 'react';

import { i18n } from './i18n';

interface DocumentTitleProps {
  children?: string;
}

export const DocumentTitle: FC<DocumentTitleProps> = (props) => {
  const { children } = props;
  const baseTitle = i18n('Яндекс ID');
  const title = children ? `${children} — ${baseTitle}` : baseTitle;

  return (
    <Head>
      <title>{title}</title>
    </Head>
  );
};
