import { Rule } from './types';

const EMAIL_REGEXP =
  /^(?=.{1,254}$)(?=.{1,64}@)[a-zA-Z0-9!#$%&'*+/=?^_`{|}~-]+(?:\.[a-zA-Z0-9!#$%&'*+/=?^_`{|}~-]+)*@[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?(?:\.[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?)*$/;

export const rules = {
  required: (): Rule<string> => ({
    name: 'required',
    validator: (value: string) => Boolean(value),
  }),

  requiredWhen: <T extends Record<string, any>>(fn: (form: T) => boolean): Rule<string> => ({
    name: 'required',
    validator: (value: string, form: T) => !fn(form) || Boolean(value),
  }),

  requiredLength: (len: number): Rule<string> => {
    return {
      name: 'required',
      validator: (value) => value.length === len,
    };
  },

  requiredWhenNotValue: (val: string): Rule<string> => ({
    name: 'required',
    validator: (value: string) => value !== val,
  }),

  maxLength: (max: number): Rule<string> => ({
    name: 'maxLength',
    validator: (value) => value.length <= max,
  }),

  email: (): Rule<string> => ({
    name: 'email',
    validator: (value) => EMAIL_REGEXP.test(value),
  }),

  regexp: (re: RegExp): Rule<string> => ({
    name: 'regexp',
    validator: (value) => re.test(value),
  }),
};

export const filters = {
  isNumber: (value: string | number) => Number.isFinite(Number(value)),
};
