import { StorageAdapter } from 'effector-storage';
import Cookies from 'js-cookie';

export interface CookiePersistConfig {
  defaultValue: any;
  expires: Date | number;
}

export function createCookieAdapter(config: CookiePersistConfig): StorageAdapter {
  const { defaultValue, expires } = config;

  return <T>(key: string) => {
    return {
      get: () => {
        try {
          const value = Cookies.get(key);

          return value ? JSON.parse(value) : defaultValue;
        } catch (_) {
          return defaultValue;
        }
      },

      set: (value: T) => {
        Cookies.set(key, JSON.stringify(value), {
          secure: true,
          expires: expires,
          sameSite: 'strict',
        });
      },
    };
  };
}
