import { Effect, attach, createEffect, createStore } from 'effector';

import { canUseDom } from '@client/shared/libs/can-use-dom';

export function createSingleEffect<Params, Done>(
  handler: (params: Params, signal: AbortSignal) => Promise<Done>,
): Effect<Params, Done> {
  const $signal = createStore(canUseDom ? new AbortController() : null);

  const abortFx = attach({
    source: $signal,
    effect(controller) {
      controller?.abort();

      return new AbortController();
    },
  });

  const requestFx = createEffect(async (params: Params) => {
    const { signal } = await abortFx();

    return handler(params, signal);
  });

  $signal.on(abortFx.doneData, (_, controller) => controller);

  return requestFx;
}
