import { FC, createContext, useContext } from 'react';

export function createModelApi<T extends (...args: any[]) => any>(creator: T) {
  type Model = ReturnType<typeof creator>;
  type ModelProps = { model: Model };

  const Context = createContext<Model | null>(null);

  function useModel() {
    const model = useContext(Context);

    if (!model) {
      throw new Error('Model not found.');
    }

    return model;
  }

  function view<T>(Component: FC<T>) {
    return (props: T & ModelProps) => (
      <Context.Provider value={props.model}>
        <Component {...props} />
      </Context.Provider>
    );
  }

  return {
    createModel: creator,
    useModel,
    view,
  };
}
