import { createContext, useContext } from 'react';

import { ServerSideProps } from '@shared/types/next-bridge';

export const EnvContext = createContext<ServerSideProps | null>(null);
export const EnvProvider = EnvContext.Provider;

export function useEnvContext() {
  const context = useContext(EnvContext);

  if (context === null) {
    throw new Error('EnvContext not found, add <EnvProvider> to app root.');
  }

  return context;
}
