export interface FormatDurationOptions {
  hour?: 'numeric' | '2-digit';
  minute?: 'numeric' | '2-digit';
  second?: 'numeric' | '2-digit';
}

export interface Duration {
  hours?: number;
  minutes?: number;
  seconds?: number;
}

export function formatDuration(duration: Duration, options: FormatDurationOptions = {}) {
  const { hour, minute, second } = options;
  const { hours = 0, minutes = 0, seconds = 0 } = duration;

  const segments: string[] = [];

  if (hour) {
    segments.push(formatNumber(hours, hour));
  }

  if (minute) {
    segments.push(formatNumber(minutes, minute));
  }

  if (second) {
    segments.push(formatNumber(seconds, second));
  }

  return segments.join(':');
}

function formatNumber(value: number, type: 'numeric' | '2-digit') {
  const str = value.toString();

  if (type === 'numeric') {
    return str;
  }

  return value < 10 ? `0${str}` : str;
}
