import PageLoader from 'next/dist/client/page-loader';

import { canUseDom } from '@client/shared/libs/can-use-dom';
import { getNextData } from '@client/shared/next';
// eslint-disable-next-line no-restricted-imports
import { Language, setI18nLang } from '@yandex-int/i18n';

const waitingSet = new Set();
let currentResolver: ((a?: unknown) => void) | undefined;

export function setCurrentClientLang() {
  if (canUseDom) {
    let locale: string | null | undefined = 'ru';

    try {
      locale = getNextData('locale');
    } catch (e) {}

    locale && setI18nLang(locale as Language);
  }
}

/******************  Глобальный перехватчик старта работы NEXTa  ********************* */
/* eslint-disable camelcase */
if (canUseDom) {
  let __NEXT_PRELOADREADY_ORIGINAl: Function | undefined;

  setCurrentClientLang();

  const origLoadPage = PageLoader.prototype.loadPage;

  PageLoader.prototype.loadPage = function (route: string) {
    return origLoadPage.call(this, route).then((result) => waitForChunksReady(result));
  };

  Object.defineProperty(window, '__NEXT_PRELOADREADY', {
    set(value) {
      __NEXT_PRELOADREADY_ORIGINAl = value;
    },
    get() {
      return (...args: unknown[]) => {
        if (typeof __NEXT_PRELOADREADY_ORIGINAl === 'function') {
          __NEXT_PRELOADREADY_ORIGINAl(...args).then(waitForChunksReady);
        } else {
          return waitForChunksReady();
        }
      };
    },
  });
}
/* eslint-enable camelcase */
/*************************************************************************************** */

export function waitForChunksReady(): Promise<void>;
export function waitForChunksReady<T>(arg: T): Promise<T>;
export function waitForChunksReady<T>(arg?: T): Promise<T | undefined> {
  if (waitingSet.size === 0) {
    return Promise.resolve(arg);
  }

  return new Promise<T | undefined>((resolve) => {
    setTimeout(() => {
      if (waitingSet.size === 0) {
        return resolve(arg);
      }

      currentResolver = () => resolve(arg);
    }, 0);
  });
}

export function addToWatingSet(chunk: string) {
  waitingSet.add(chunk);
}

export function removeFromWatingSet(chunk: string) {
  waitingSet.delete(chunk);

  if (waitingSet.size === 0 && currentResolver) {
    currentResolver();
    currentResolver = undefined;
  }
}
