/* eslint-disable no-restricted-imports */
import { canUseDom } from '@client/shared/libs/can-use-dom';
import { LANG } from '@shared/i18n';
import origI18nFactory, {
  I18nOptions,
  I18nRaw,
  getI18nLang as getI18nLangOrig,
  i18nRaw as origI18nRaw,
  setI18nLang as setI18nLangOrig,
} from '@yandex-int/i18n';

import { addToWatingSet, removeFromWatingSet } from './async-helpers';

export type { LANG };

export type Keyset<T> = Record<LANG, T>;

export const setI18nLang = setI18nLangOrig as (locale: LANG) => void;
export const getI18nLang = getI18nLangOrig as () => LANG;

export function markAsyncChunk(keyset?: Keyset<unknown>, chunk?: string) {
  if (canUseDom && chunk) {
    if (!keyset) {
      addToWatingSet(chunk);
    } else {
      removeFromWatingSet(chunk);
    }
  }
}

export function i18nFactory<T>(keyset?: Keyset<T>, chunk?: string) {
  markAsyncChunk(keyset, chunk);

  return origI18nFactory(keyset as any) as (key: keyof T, options?: I18nOptions) => string;
}

/**
 * Отличие от typedI18nFactory: https://github.yandex-team.ru/search-interfaces/frontend/tree/master/packages/i18n#интеграция-с-компонентами
 * TLDR: позволяет подставлять react компоненты, возвращает массив, а не строку
 */
export function i18nRawFactory<T>(keyset?: Keyset<T>, chunk?: string) {
  markAsyncChunk(keyset, chunk);

  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  return origI18nRaw(keyset as any) as (key: keyof T, options?: I18nOptions) => I18nRaw;
}
