import { useRouter } from 'next/router';
import { useEffect } from 'react';

import { isProdLike } from '@shared/helpers/isProdLike';
import { YEnv } from '@shared/types/env';

import * as metrika from './metrika';
import { getLogDataFromElement } from './utils';

export * from './metrika';
export { logProps } from './utils';

export const useMetrikaInit = (yenv: YEnv) => {
  const router = useRouter();

  const metrikaId = isProdLike(yenv) ? '784657' : '88077604';

  useEffect(() => {
    metrika.init(metrikaId);

    function handleChangeComplete() {
      metrika.pageview();
    }

    function onDocumentClick(event: MouseEvent) {
      const data = getLogDataFromElement(event.target as HTMLElement);

      if (data !== null && data.type !== undefined) {
        const { type, ...payload } = data;

        metrika.sendParams(`click.${type}`, payload);
      }
    }

    document.addEventListener('pointerup', onDocumentClick, true);
    router.events.on('routeChangeComplete', handleChangeComplete);

    return () => {
      router.events.off('routeChangeComplete', handleChangeComplete);
      document.removeEventListener('pointerup', onDocumentClick, true);
    };
  }, [metrikaId, router.events]);
};
