export function initialize(ymId?: string, options?: any) {
  if (!ymId) {
    return;
  }
  let customOptions: any = {};
  const defaultOptions = {
    id: ymId,
    clickmap: true,
    trackLinks: true,
    accurateTrackBounce: true,
  };

  if (options) {
    customOptions = options;
    customOptions.id = ymId;
  }
  (function (d, w, c) {
    // @ts-expect-error
    (w[c] = w[c] || []).push(function () {
      try {
        const Ya = w.Ya;

        // @ts-expect-error
        w[`yaCounter${ymId}`] = new Ya.Metrika(options ? customOptions : defaultOptions);
      } catch (e) {}
    });

    const n = d.getElementsByTagName('script')[0];
    const s = d.createElement('script');
    const f = function () {
      // @ts-expect-error
      n.parentNode.insertBefore(s, n);
    };

    s.type = 'text/javascript';
    s.async = true;
    s.src = 'https://mc.yandex.ru/metrika/watch.js';

    if (w.opera === '[object Opera]') {
      d.addEventListener('DOMContentLoaded', f, false);
    } else {
      f();
    }
  })(document, window, 'yandex_metrika_callbacks');
}
