import { canUseDom } from '@client/shared/libs/can-use-dom';

import { initialize } from './initialize';

let key: string;
let defferedParams: any[] = [];

export function init(code: string) {
  key = `yaCounter${code}`;

  // @ts-expect-error
  if (canUseDom && !window[key] && code) {
    initialize(code);

    // Ждем инициализацию счетчика и отправляем параметры
    const interval = setInterval(() => {
      // @ts-expect-error
      if (window[key]) {
        defferedParams.forEach((item) => {
          Array.isArray(item) ? rawParams(...item) : rawParams(item);
        });
        defferedParams = [];

        clearInterval(interval);
      }
    }, 500);
  }
}

export function pageview() {
  // @ts-expect-error
  if (window[key]) {
    // @ts-expect-error
    window[key].hit(window.location.pathname);
  }
}

// @ts-expect-error
export function reachGoal(...args) {
  // @ts-expect-error
  if (window[key]) {
    // @ts-expect-error
    window[key].reachGoal(...args);
  }
}

// @ts-expect-error
export function rawParams(...args) {
  // @ts-expect-error
  if (window[key]) {
    // @ts-expect-error
    window[key].params(...args);
  } else {
    // Сохраняем параметры для того,
    // чтобы отправить их после инициализации счетчика
    defferedParams.push(args);
  }
}

export function sendParams(paramkey: string, data?: any) {
  const param = { id: { [paramkey]: data || { value: true } } };

  rawParams(param);
}
