import { safelyParseJSON } from '@shared/helpers';

export function logProps(type: string, data: Record<string, any> = { value: true }) {
  return {
    'data-log': JSON.stringify({ type, ...data }),
  };
}

export function getLogDataFromElement(element: HTMLElement | null) {
  let node = element;

  while (node) {
    if (node.dataset.log) {
      return safelyParseJSON(node.dataset.log);
    }

    node = node.parentElement;
  }

  return null;
}
