import { createContext, useContext } from 'react';

// eslint-disable-next-line @typescript-eslint/no-empty-interface
export interface Scope {}

const ScopeContext = createContext<Scope | null>(null);

ScopeContext.displayName = 'ScopeContext';

export const Provider = ScopeContext.Provider;

export function useScope() {
  const scope = useContext(ScopeContext);

  if (!scope) {
    throw new Error('No scope found, consider adding <Provider> to app root');
  }

  return scope;
}
