import { createContext, useContext } from 'react';

import { StoreManager } from './store-manager';

const StoreManagerContext = createContext<StoreManager | null>(null);

StoreManagerContext.displayName = 'StoreManagerContext';

export const StoreManagerProvider = StoreManagerContext.Provider;

export function useStoreManager() {
  const manager = useContext(StoreManagerContext);

  if (!manager) {
    throw new Error('Store manager not found, consider adding <StoreManagerProvider> to app root');
  }

  return manager;
}
