export interface Store {
  start?: () => Promise<void> | void;
  reset?: () => Promise<void> | void;
}

export interface HydratableStore extends Store {
  hydrate: (context: any) => void;
}

export interface AsyncStore<T = unknown> {
  data: T | null;
  isLoading: boolean;
}

export interface Type<T> extends Function {
  new (...args: any[]): T;
}
